global files "C:/Users/WB326023/Dropbox/WB/BPEA/BPEA Replication/"
global BPEAraw "$files/dataraw"
global BPEAout "$files/dataout"
global BPEAtemp "$files/temp"
global BPEAplots "$files/plots"

* colour blind friendly palette
global cblue "0 114 178"
global cred "213 94 0"
global corange "230 159 0"
global cyellow "240 228 66"
global cgreen "0 158 115"
global cblack "0 0 0"
global cgrey "60 60 60"
global cpurple "204 121 167"
global cskyblue "86 180 233"

global graphsettings graphregion(color(white)) bgcolor(white) ylabel(, grid glcolor(gs15)) scale(0.8)


// figure 1 - world imports
use  "$BPEAout/goods/wide_region_imports_completeCases.dta", clear
* append using "$BPEAout/v2_data/imf_forecast_gdp_trade_2022_2027.dta"

* merge 84-1991 data
merge 1:1 year using "$BPEAout/goods/wide_region_84_91_all_trade_data.dta", update
sort year

drop import_total_valueWLD
drop export*
keep if inrange(year, 1989, 2021)

keep year *WLD
merge 1:1 year using "$BPEAout/USAdeflator.dta", keep(1 3) nogen
tsset year

* percentage of gdp is in nominal term
gen import_total_valueWLD = import_goods_valueWLD+import_services_valueWLD
gen n_import_total_shareWLD = (import_total_valueWLD/gdpWLD)*100

* money value in real GDP
replace gdpWLD = gdpWLD/vNGDP_D
gen r_import_total_valueWLD = import_total_valueWLD/vNGDP_D
replace r_import_total_valueWLD = import_total_valueWLD/1000000000000

twoway 	(tsline n_import_total_shareWLD if year <= 2021, yaxis(1) lc("$cblue") lwidth(thick) lpattern(dot)) || ///
		(tsline n_import_total_shareWLD if year >= 2021, yaxis(1) lc("$cblue") lpattern(shortdash_dot))  || ///
		(tsline r_import_total_valueWLD if year <= 2021, yaxis(1) yscale(r(0 30)) lc("$cblue")) || ///
		(tsline r_import_total_valueWLD if year >= 2021, yaxis(1) lc("$cblue") lpattern(dash)), ///
		$graphsettings ///
		ytitle("", axis(1)) xtitle("") ///
		ylabel(0(10)30, axis(1)) ///
		tlabel(1989 1999 2009 2019) ///
		title("World imports of goods and services", color(black)) ///
		legend(order(1 3) position(1) /// 
				label(3 "Value in US$ trillions (2018 prices)") label(1 "Percent of world GDP") ///
				label(2 "") label(4 "") rows(1) ///
				region(lstyle(none)))

graph save "$BPEAout/v2_graphs/vf_fig1_imports_WLD.gph", replace
graph export "$BPEAplots/vf/pdf/vf_fig1_imports_WLD.pdf", replace
graph export "$BPEAplots/vf/png/vf_fig1_imports_WLD.png", replace
graph export "$BPEAplots/vf/eps/vf_fig1_imports_WLD.eps", replace
local call


// figure 2 - trends in globalization exoports
use  "$BPEAout/goods/wide_region_exports_completeCases.dta", clear
* append forecast data
*append using "$BPEAout/v2_data/imf_forecast_gdp_trade_2022_2027.dta"

* merge 84-1991 data, update for missing USA and China
merge 1:1 year using "$BPEAout/goods/wide_region_84_91_all_trade_data.dta", update
sort year

drop export_total_value* *WLD *EUN import*
keep if inrange(year, 1989, 2021)

tsset year
local regions "CHN ROW IND USA DEU"
foreach r of local regions {
	gen export_total_value`r' = export_goods_value`r' + export_services_value`r'
	replace export_total_value`r' = export_total_value`r'/1000000000000
}
lab var export_total_valueCHN "China"
lab var export_total_valueROW "Rest of the world"
lab var export_total_valueIND "India"
lab var export_total_valueUSA "United States"
lab var export_total_valueDEU "Germany"
lab var export_shareROW "Rest of the world"

// total value for all countries, using ROW
foreach v of varlist export_share*  { 
	 replace `v'=`v'*100
	 su `v' if year == 2021 , meanonly 
	 local name: variable label `v'
	 if "`v'"=="export_shareIND" {
	     local m = `r(mean)'-0.5
		 local call `call' text(`m' 2021 "`name'",  place(e))
	 } 
	 else if "`v'"=="export_shareCHN" {
	     local m = `r(mean)'+0.5
		 local call `call' text(`m' 2021 "`name'",  place(e))
	 } 
	 else {
		 local call `call' text(`r(mean)' 2021 "`name'",  place(e))
	 }
}

twoway 	(tsline export_shareDEU if year < 2022, lc("$cblue")) || ///
		(tsline export_shareDEU if year >= 2021, lc("$cblue") lpattern(shortdash)) || ///
		(tsline export_shareCHN if year < 2022, lc("$cred")) || ///
		(tsline export_shareCHN if year >= 2021, lc("$cred") lpattern(shortdash)) || ///
		(tsline export_shareIND if year < 2022, lc("$cgreen")) || ///
		(tsline export_shareIND if year >= 2021, lc("$cgreen") lpattern(shortdash)) || ///
		(tsline export_shareUSA if year < 2022, lc("$corange")) || ///
		(tsline export_shareUSA if year >= 2021, lc("$corange") lpattern(shortdash)) || ///
		(tsline export_shareROW if year < 2022, lc("$cgrey")) || ///
		(tsline export_shareROW if year >= 2021, lc("$cgrey") lpattern(shortdash)), ///
		`call' ///
		$graphsettings ///
		legend(off) tlabel(1989(10)2019) tscale(r(1989 2028)) ///
		ytitle("Percent of country's GDP") xtitle("") ///
		yscale(r(0 50)) ///
		ylabel(0(10)50) ///
		title("Panel A: Exports of goods and services", color(black))  

graph save "$BPEAout/v2_graphs/vf_fig2_panelA.gph", replace
*graph export "$BPEAplots/vf/vf_fig2_panelA.pdf", replace
*graph export "$BPEAplots/vf/vf_fig2_panelA.png", replace
*graph export "$BPEAplots/vf/vf_fig2_panelA.eps", replace
local call

// panel b - intermediate goods trade 
use  "$BPEAout/v2_data/panel_b_intermediate_imports_share_completeCases.dta", clear
merge 1:1 year using "$BPEAout/v2_data/imports_intermediates_89_91.dta", update 
tsset year
keep if year >=1989
drop *EUN

* get positions for explanatory text from latest value
foreach v of varlist import_interm_share*  { 
	replace `v' = `v'*100
	 su `v' if year == 2021 , meanonly 
	 local name: variable label `v'
	 if "`v'" == "import_interm_shareCHN" {
		local call `call' text(`r(mean)' 2021 "`name'",  place(r))
	} 
	else if "`v'" == "import_interm_shareIND" {
		local m = `r(mean)'
		local call `call' text(`m' 2021 "`name'",  place(r))
	}
	else if "`v'" == "import_interm_shareROW" {
		local m = `r(mean)'
		local call `call' text(`m' 2021 "`name'",  place(r))
	}
	else if "`v'" == "import_interm_shareDEU" {
		local m = `r(mean)'
		local call `call' text(`m' 2021 "`name'",  place(r))
	}
	else {
	 local call `call' text(`r(mean)' 2021 "`name'",  place(r))
	}
} 

twoway 	(tsline import_interm_shareDEU, lcolor("$cblue")) || ///
		(tsline import_interm_shareCHN, lcolor("$cred")) || ///
		(tsline import_interm_shareIND, lcolor("$cgreen")) || ///
		(tsline import_interm_shareUSA, lcolor("$corange")) || ///
		(tsline import_interm_shareROW, lcolor("$cgrey")), ///
		`call' ///
		$graphsettings ///
		legend(off) tlabel(1989(10)2019) tscale(r(1989 2028))  ///
		ylabel(0(5)20, gmin gmax) ///
		title("Panel B: Intermediate goods imports", color(black)) ///
		ytitle("Percent of country's GDP") xtitle("")

graph save "$BPEAout/v2_graphs/vf_fig2_panelB.gph", replace
*graph export "$BPEAplots/v2/vf_fig2_panelB.pdf", replace
*graph export "$BPEAplots/v2/vf_fig2_panelB.png", replace
*graph export "$BPEAplots/v2/vf_fig2_panelB.eps", replace
local call


// panel c - FDI
use "$BPEAout/v2_data/panel_c_fdi.dta", clear
keep if year >= 1989
drop *EUN
tsset year

lab var shareInFdiROW "Rest of the world"
* get positions for explanatory text from latest value
foreach v of varlist shareInFdiCHN shareInFdiDEU shareInFdiUSA shareInFdiIND shareInFdiROW { 
	replace `v' = `v'*100
	 su `v' if year == 2021 , meanonly 
	 local name: variable label `v'
	 local call `call' text(`r(mean)' 2021 "`name'",  place(r))  	 

} 

twoway 	(tsline shareInFdiDEU, lcolor("$cblue")) || ///
		(tsline shareInFdiCHN, lcolor("$cred")) || ///
		(tsline shareInFdiIND, lcolor("$cgreen")) || ///
		(tsline shareInFdiUSA, lcolor("$corange")) || ///
		(tsline shareInFdiROW, lcolor("$cgrey")), ///
		`call' ///
		$graphsettings ///
		legend(off) tlabel(1989(10)2019) tscale(r(1989 2028))  ///
		title("Panel C: Stock of inward foreign direct investment", color(black)) ///
		ytitle("Percent of country's GDP") xtitle("")

graph save "$BPEAout/v2_graphs/vf_fig2_panelC.gph", replace
*graph export "$BPEAplots/v2/vf_fig2_panelC.pdf", replace
*graph export "$BPEAplots/v2/vf_fig2_panelC.png", replace
*graph export "$BPEAplots/v2/vf_fig2_panelC.eps", replace
local call

// panel d - in migrants
use "$BPEAout/v2_data/panel_d_inMigrants.dta", clear
keep if year >= 1980 & year <= 2020
tsset year
lab var mig_shareROW "Rest of the world"

* get positions for explanatory text from latest value
foreach v of varlist mig_shareCHN mig_shareDEU mig_shareUSA mig_shareIND mig_shareROW { 
	replace `v' = `v'*100
	su `v' if year == 2020 , meanonly 
	local name: variable label `v'
	if "`v'" == "mig_shareIND" {
	loc m = `r(mean)'+.5
	local call `call' text(`m' 2020 "`name'",  place(r))
	} 
	else {
	local call `call' text(`r(mean)' 2020 "`name'",  place(r))
	} 	 
} 

twoway 	(tsline mig_shareDEU, lcolor("$cblue")) || ///
		(tsline mig_shareCHN, lcolor("$cred")) || ///
		(tsline mig_shareIND, lcolor("$cgreen")) || ///
		(tsline mig_shareUSA, lcolor("$corange")) || ///
		(tsline mig_shareROW, lcolor("$cgrey")), ///
		`call' ///
		$graphsettings ///
		legend(off) tlabel(1989(10)2019) tscale(r(1989 2028))  ///
		title("Panel D: Stock of inward migrants", color(black)) ///
		ytitle("Percent of country's population") xtitle("")

graph save "$BPEAout/v2_graphs/vf_fig2_panelD.gph", replace
*graph export "$BPEAplots/v2/vf_fig2_panelD.pdf", replace
*graph export "$BPEAplots/v2/vf_fig2_panelD.png", replace
*graph export "$BPEAplots/v2/vf_fig2_panelD.eps", replace
local call

// combine all graphs
cd "$BPEAout/v2_graphs"
local settings xsize(16) ysize(9) graphregion(color(white)) title("Recent trends in globalization", color(black)) scale(0.8)
graph combine "vf_fig2_panelA.gph" "vf_fig2_panelB.gph"  "vf_fig2_panelC.gph" "vf_fig2_panelD.gph", `settings' 

graph save "$BPEAout/v2_graphs/vf_fig2.gph", replace
graph export "$BPEAplots/vf/pdf/vf_fig2.pdf", replace
graph export "$BPEAplots/vf/png/vf_fig2.png", width(4800) height(2700) replace
graph export "$BPEAplots/vf/eps/vf_fig2.eps", replace
local call




// Robustness Appendix Figure A1
local run = 1
if `run' == 1 {

	// robust for fig2 panel c
	use  "$BPEAout/v2_data/fig2_panel_c_robust_fdi.dta", clear
	tsset year

	* get positions for explanatory text from latest value
	foreach v of varlist rfdi_shDEU rfdi_shCHN rfdi_shIND rfdi_shUSA rfdi_shROW { 
		replace `v'=`v'*100
		su `v' if year == 2017 , meanonly 
		local name: variable label `v'
		local call `call' text(`r(mean)' 2017 "`name'",  place(r))  	 
	} 

	twoway 	(tsline rfdi_shDEU, lcolor("$cblue")) || ///
			(tsline rfdi_shCHN, lcolor("$cred")) || ///
			(tsline rfdi_shIND, lcolor("$cgreen")) || ///
			(tsline rfdi_shUSA, lcolor("$corange")) || ///
			(tsline rfdi_shROW, lcolor("$cgrey")), ///
			`call' ///
			$graphsettings ///
		legend(off) tlabel(2009 2019) tscale(r(2007 2017)) ///
		title("Capital investment (Coppola, Maggiori, Neiman, and Schreger 2021)", color(black)) ///
		ytitle("Restated foreign holding of local bonds and equity (% of GDP)") xtitle("")
		
	graph save "$BPEAout/v2_graphs/vf_fig2_panel_c_robustness.gph", replace
	graph export "$BPEAplots/vf/pdf/vf_fig2_panel_c_robustness.pdf", replace
	graph export "$BPEAplots/vf/png/vf_fig2_panel_c_robustness.png", replace
	local call
}



// data sets for paper
local run = 0
if `run' == 1 {

	// panel A data set
	use  "$BPEAout/goods/wide_region_exports_completeCases.dta", clear
	* append forecast data
	*append using "$BPEAout/v2_data/imf_forecast_gdp_trade_2022_2027.dta"

	* merge 84-1991 data, update for missing USA and China
	merge 1:1 year using "$BPEAout/goods/wide_region_84_91_all_trade_data.dta", update nogen
	sort year

	drop import*
	local regions "CHN DEU IND ROW WLD USA" 
	foreach r of local regions {
		replace export_total_value`r'=export_goods_value`r'+export_services_value`r' if missing(export_total_value`r')
	}

	drop *EUN *WLD

	reshape long export_goods_value export_services_value export_total_value gdp export_share, i(year) j(region) string

	order year region export_goods_value export_services_value export_total_value gdp export_share
	replace export_share=export_share*100

	sort region year

	export excel using "$BPEAplots/vf/datasets/vf_fig2_panelA_exports.xlsx", firstrow(variables) replace

	// figure 1 dataset for services
	// 2005-2021, EBOPS 2010
	import delimited "$BPEAraw/services/WtoDataCSV_20221103084838/WtoData_20221103134600.csv", clear delimiter(comma) encoding(windows-1252) 
	keep reportingeconomyiso3acode reportingeconomy partnereconomyiso3acode partnereconomy productsectorcode productsector unit year value
	ren (reportingeconomyiso3acode reportingeconomy partnereconomyiso3acode partnereconomy) ///
		(reporteriso3 reporter partneriso3 partner)
		
	ren (productsectorcode productsector) (productcode product)
	* keep if productcode=="S"

	replace reporteriso3 = "WLD" if reporter=="World"
	replace partneriso3 = "WLD" if partner=="World"
	sort productcode partneriso3 year
	drop if inlist(reporteriso3, "EEC")
	drop if inlist(partneriso3, "EEC")
	drop if missing(partneriso3)
	drop if missing(reporteriso3)

	keep if partneriso3=="WLD"
	replace reporteriso3 = "TWN" if reporteriso3=="CHT"
	replace reporteriso3 = "ROU" if reporteriso3=="ROM"
	replace partneriso3 = "TWN" if partneriso3=="CHT"
	replace partneriso3 = "ROU" if partneriso3=="ROM"

	keep reporteriso3 partneriso3 year value productcode product
	rename reporteriso3 countrycode
	merge m:1 countrycode using "$BPEAout/countries.dta", keep(1 3) nogen keepusing(region)	

	replace region = "WLD" if countrycode=="WLD"
	replace region = "WLD" if partneriso3=="WLD" & countrycode=="WLD"
	replace region = "ROW" if missing(region)
	rename countrycode reporteriso3
	gen export_services_value = value*1000000
	drop value

	sort reporteriso3 productcode year
	drop if productcode=="GSOX"

	collapse (sum) export_services_value, by(year region partneriso3 productcode product)

	merge m:1 region year using "$BPEAout/wb_gdp_collapsed.dta", keep(1 3) nogen keepusing(gdp)

	gen export_services_share = (export_services_value/gdp)*100
	gen aggregate_level = length(productcode)
	order region partneriso3 aggregate_level productcode product year export_services_value

	sort region productcode year

	export excel using  "$BPEAplots/vf/datasets/vf_fig2_panelA_exports_services.xlsx", replace firstrow(variables)
}